'******************************************************************************
'*   Name    : Keypad.BAS                                                     *
'*   Author  : Trent Jackson                                                  *
'*   Notice  : No Copyright                                                   *
'*           :                                                                *
'*   Date    : 8/5/2007                                                       *
'*   Version : 1.0                                                            *
'* Target PIC: 16f628                                                         *
'******************************************************************************


   '// 3x3 Keypad - Rows as inputs, Cols as outputs...
   'Rows: RA3      Cols: RB1                     
   '      RB3            RA2                      
   '      RB2            RA4                      
   '      RB0                                     
   '//
   ' RB5: LED & Buzzer ...                            
   ' RA0: TX to PC's Serial Port                  
   
   Include "modedefs.bas"   ' Serial Protocol
   Define   OSC 4           ' 4MHz crystal used
   CMCON = 7                ' Disable on-chip comparator, PORTA in digital mode
              
   '// Define port pins as inputs and outputs ...
   TRISA  = %00001000
   TRISB  = %00001101
                 
   '// Declare Variables...
   Col_A     VAR PORTB.1
   Col_B     VAR PORTA.2
   Col_C     VAR PORTA.4
   
   Row_A     VAR PORTA.3
   Row_B     VAR PORTB.3
   Row_C     VAR PORTB.2
   Row_D     VAR PORTB.0
  
   Buzzer    VAR PORTB.5
   RX_To_PC  VAR PORTA.0
    
   Scan_Col  VAR BYTE       ' Counter - denoting current col in scan 
   Key_Press VAR BYTE       ' Contains value of key (0-9) & * + #
   Key_Down  VAR BYTE       ' Flag set true when key is depressed
   Allow_Key VAR BYTE       ' Flag - disallow multiple keys being pressed
   I         VAR byte       ' General working var
    
   Scan_Keypad:
   
   '// Scan cols 
      @ incf _Scan_Col, 1   ' Inc col pos...
    
      SELECT CASE Scan_Col  ' Col (1-3)
             
             CASE 1
                  Col_A = 0 ' Switch on col (active low)    
                  Col_B = 1 ' Col off    
                  Col_C = 1 ' Col off   
                           
                  '// 3 Key
                           IF Row_A = 0 THEN        ' Key down? ... 
                              IF Allow_Key = 0 THEN ' Any other key down?
                                 Key_Press = 3      ' Load var w/value of key           
                                 Allow_Key = 1      ' Disallow other keys
                              ENDIF   
                           ENDIF                          
                  '// 6 Key
                           IF Row_B = 0 THEN
                              IF Allow_Key = 0 THEN 
                                 Key_Press = 6                 
                                 Allow_Key = 1
                              ENDIF   
                           ENDIF
                  '// 9 Key
                           IF Row_C = 0 THEN
                              IF Allow_Key = 0 THEN 
                                 Key_Press = 9                 
                                 Allow_Key = 1
                              ENDIF   
                           ENDIF
                  '// # Key
                           IF Row_D = 0 THEN
                              IF Allow_Key = 0 THEN 
                                 Key_Press = 35                 
                                 Allow_Key = 1
                              ENDIF   
                           ENDIF
                  
             CASE 2
                  Col_A = 1    
                  Col_B = 0    
                  Col_C = 1    
                           
                  '// 2 Key
                           IF Row_A = 0 THEN
                              IF Allow_Key = 0 THEN 
                                 Key_Press = 2                 
                                 Allow_Key = 1
                              ENDIF   
                           ENDIF
                  '// 5 Key
                           IF Row_B = 0 THEN
                              IF Allow_Key = 0 THEN 
                                 Key_Press = 5                 
                                 Allow_Key = 1
                              ENDIF   
                           ENDIF
                  '// 8 Key 
                           IF Row_C = 0 THEN
                              IF Allow_Key = 0 THEN 
                                 Key_Press = 8                 
                                 Allow_Key = 1
                              ENDIF   
                           ENDIF
                  '// 0 Key
                           IF Row_D = 0 THEN
                              IF Allow_Key = 0 THEN 
                                 Key_Press = 0                 
                                 Allow_Key = 1
                              ENDIF   
                           ENDIF

             CASE 3
                  Col_A = 1     
                  Col_B = 1     
                  Col_C = 0

                  '// 1 Key
                           IF Row_A = 0 THEN
                              IF Allow_Key = 0 THEN 
                                 Key_Press = 1                 
                                 Allow_Key = 1
                              ENDIF   
                           ENDIF
                  '// 4 Key
                           IF Row_B = 0 THEN
                              IF Allow_Key = 0 THEN 
                                 Key_Press = 4                 
                                 Allow_Key = 1
                              ENDIF   
                           ENDIF
                   '// 7 Key
                          IF Row_C = 0 THEN
                              IF Allow_Key = 0 THEN 
                                 Key_Press = 7                 
                                 Allow_Key = 1
                              ENDIF   
                           ENDIF
                  '// * Key
                           IF Row_D = 0 THEN
                              IF Allow_Key = 0 THEN 
                                 Key_Press = 42                 
                                 Allow_Key = 1
                              ENDIF   
                           ENDIF

                  Scan_Col = 0   
   END SELECT
   
   '// Ouput key serially, once only
   IF Key_Down <> Key_Press THEN                    ' Key already been sent? 
      IF Key_Press <> 255 THEN                      ' 255 denotes no key press
         IF Key_Press = 42 OR Key_Press = 35 THEN   ' Numerical key?
            SEROUT RX_To_PC, N2400, [Key_press]     ' No
         ELSE                                       ' 
            SEROUT RX_To_PC, N2400, [#Key_press]    ' Yes
         ENDIF
         
         '// Brief chrip of the piezo & flash of the LED
         for i = 0 to 20
             toggle buzzer
             pause 5
         next    
      ENDIF
      Key_Down = Key_Press                          ' Copy of key just sent 
      Buzzer = 0                                    ' Make sure LED is off
   ENDIF
   
   '// Check for key release, all cols on (active low) ...
   Col_A = 0     
   Col_B = 0     
   Col_C = 0

   '// Reset flags allowing other keys to be processed if no keys are depressed
   IF Row_A = 1 THEN
      IF Row_B = 1 THEN
         IF Row_C = 1 THEN
            IF Row_D = 1 THEN
               Allow_Key = 0
               Key_Down = 0
               Key_Press = 255
            ENDIF
         ENDIF
      ENDIF
   ENDIF
               
   GOTO Scan_Keypad                                 ' Loop back                   

